/*
 * Decompiled with CFR 0.152.
 */
package image_processing.engine.canny;

public abstract class Sobel {
    private static final int[][] MASK_H;
    private static final int[][] MASK_V;

    static {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[2] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -2;
        nArray2[2] = 2;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = -1;
        nArray3[2] = 1;
        nArrayArray[2] = nArray3;
        MASK_H = nArrayArray;
        MASK_V = new int[][]{{-1, -2, -1}, new int[3], {1, 2, 1}};
    }

    public static int[][] Horizontal(int[][] raw) {
        int[][] out = null;
        int height = raw.length;
        int width = raw[0].length;
        if (height > 2 && width > 2) {
            out = new int[height - 2][width - 2];
            int r = 1;
            while (r < height - 1) {
                int c = 1;
                while (c < width - 1) {
                    int sum = 0;
                    int kr = -1;
                    while (kr < 2) {
                        int kc = -1;
                        while (kc < 2) {
                            sum += MASK_H[kr + 1][kc + 1] * raw[r + kr][c + kc];
                            ++kc;
                        }
                        ++kr;
                    }
                    out[r - 1][c - 1] = sum;
                    ++c;
                }
                ++r;
            }
        }
        return out;
    }

    public static int[][] Vertical(int[][] raw) {
        int[][] out = null;
        int height = raw.length;
        int width = raw[0].length;
        if (height > 2 || width > 2) {
            out = new int[height - 2][width - 2];
            int r = 1;
            while (r < height - 1) {
                int c = 1;
                while (c < width - 1) {
                    int sum = 0;
                    int kr = -1;
                    while (kr < 2) {
                        int kc = -1;
                        while (kc < 2) {
                            sum += MASK_V[kr + 1][kc + 1] * raw[r + kr][c + kc];
                            ++kc;
                        }
                        ++kr;
                    }
                    out[r - 1][c - 1] = sum;
                    ++c;
                }
                ++r;
            }
        }
        return out;
    }
}

