/*
 * Decompiled with CFR 0.152.
 */
package image_processing.engine.canny;

import image_processing.engine.canny.Gaussian;
import image_processing.engine.canny.ImageUtils;
import image_processing.engine.canny.Sobel;
import java.awt.image.BufferedImage;

public abstract class JCanny {
    private static final int GAUSSIAN_RADIUS = 0;
    private static final double GAUSSIAN_INTENSITY = 1.0;
    private static int stDev;
    private static int mean;
    private static int numDev;
    private static double tHi;
    private static double tLo;
    private static double tFract;
    private static int[][] dir;
    private static int[][] gx;
    private static int[][] gy;
    private static double[][] mag;

    public static BufferedImage CannyEdges(BufferedImage img, int numberDeviations, double fract, int outlineColor) {
        int[][] raw = null;
        int[][] blurred = null;
        BufferedImage edges = null;
        numDev = numberDeviations;
        tFract = fract;
        if (img != null && numberDeviations > 0 && fract > 0.0) {
            raw = ImageUtils.GSArray(img);
            blurred = Gaussian.BlurGS(raw, 0, 1.0);
            gx = Sobel.Horizontal(blurred);
            gy = Sobel.Vertical(blurred);
            JCanny.Magnitude();
            JCanny.Direction();
            JCanny.Suppression();
            edges = ImageUtils.GSImg(JCanny.Hysteresis());
        }
        return ImageUtils.EdgesToImg(edges, 0, outlineColor);
    }

    private static void Magnitude() {
        int c;
        double sum = 0.0;
        double var = 0.0;
        int height = gx.length;
        int width = gx[0].length;
        double pixelTotal = height * width;
        mag = new double[height][width];
        int r = 0;
        while (r < height) {
            c = 0;
            while (c < width) {
                JCanny.mag[r][c] = Math.sqrt(gx[r][c] * gx[r][c] + gy[r][c] * gy[r][c]);
                sum += mag[r][c];
                ++c;
            }
            ++r;
        }
        mean = (int)Math.round(sum / pixelTotal);
        r = 0;
        while (r < height) {
            c = 0;
            while (c < width) {
                double diff = mag[r][c] - (double)mean;
                var += diff * diff;
                ++c;
            }
            ++r;
        }
        stDev = (int)Math.sqrt(var / pixelTotal);
    }

    private static void Direction() {
        int height = gx.length;
        int width = gx[0].length;
        double piRad = 57.29577951308232;
        dir = new int[height][width];
        int r = 0;
        while (r < height) {
            int c = 0;
            while (c < width) {
                double angle = Math.atan2(gy[r][c], gx[r][c]) * piRad;
                if (angle < 0.0) {
                    angle += 360.0;
                }
                JCanny.dir[r][c] = angle <= 22.5 || angle >= 157.5 && angle <= 202.5 || angle >= 337.5 ? 0 : (angle >= 22.5 && angle <= 67.5 || angle >= 202.5 && angle <= 247.5 ? 45 : (angle >= 67.5 && angle <= 112.5 || angle >= 247.5 && angle <= 292.5 ? 90 : 135));
                ++c;
            }
            ++r;
        }
    }

    private static void Suppression() {
        int height = mag.length - 1;
        int width = mag[0].length - 1;
        int r = 1;
        while (r < height) {
            int c = 1;
            while (c < width) {
                double magnitude = mag[r][c];
                switch (dir[r][c]) {
                    case 0: {
                        if (!(magnitude < mag[r][c - 1]) || !(magnitude < mag[r][c + 1])) break;
                        JCanny.mag[r - 1][c - 1] = 0.0;
                        break;
                    }
                    case 45: {
                        if (!(magnitude < mag[r - 1][c + 1]) || !(magnitude < mag[r + 1][c - 1])) break;
                        JCanny.mag[r - 1][c - 1] = 0.0;
                        break;
                    }
                    case 90: {
                        if (!(magnitude < mag[r - 1][c]) || !(magnitude < mag[r + 1][c])) break;
                        JCanny.mag[r - 1][c - 1] = 0.0;
                        break;
                    }
                    case 135: {
                        if (!(magnitude < mag[r - 1][c - 1]) || !(magnitude < mag[r + 1][c + 1])) break;
                        JCanny.mag[r - 1][c - 1] = 0.0;
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    private static int[][] Hysteresis() {
        int height = mag.length - 1;
        int width = mag[0].length - 1;
        int[][] bin = new int[height - 1][width - 1];
        tHi = mean + numDev * stDev;
        tLo = tHi * tFract;
        int r = 1;
        while (r < height) {
            int c = 1;
            while (c < width) {
                double magnitude = mag[r][c];
                if (magnitude >= tHi) {
                    bin[r - 1][c - 1] = 255;
                } else if (magnitude < tLo) {
                    bin[r - 1][c - 1] = 0;
                } else {
                    boolean connected = false;
                    int nr = -1;
                    while (nr < 2) {
                        int nc = -1;
                        while (nc < 2) {
                            if (mag[r + nr][c + nc] >= tHi) {
                                connected = true;
                            }
                            ++nc;
                        }
                        ++nr;
                    }
                    bin[r - 1][c - 1] = connected ? 255 : 0;
                }
                ++c;
            }
            ++r;
        }
        return bin;
    }
}

