/*
 * Decompiled with CFR 0.152.
 */
package image_processing.engine.canny;

import java.awt.image.BufferedImage;

public abstract class ImageUtils {
    public static BufferedImage mergeImages(BufferedImage[] images, int backgroundColor) {
        if (images.length == 0) {
            return null;
        }
        int W = -1;
        int H = -1;
        int idImg = 0;
        while (idImg < images.length) {
            if (images[idImg] != null) {
                W = images[idImg].getWidth();
                H = images[idImg].getHeight();
                break;
            }
            ++idImg;
        }
        if (W == -1) {
            return null;
        }
        backgroundColor |= 0xFF000000;
        BufferedImage mergedImg = new BufferedImage(W, H, 2);
        int x = 0;
        while (x < W) {
            int y = 0;
            while (y < H) {
                int color = backgroundColor;
                BufferedImage[] bufferedImageArray = images;
                int n = images.length;
                int n2 = 0;
                while (n2 < n) {
                    int c;
                    BufferedImage img = bufferedImageArray[n2];
                    if (img != null && (c = img.getRGB(x, y)) != 0) {
                        color = c;
                        break;
                    }
                    ++n2;
                }
                mergedImg.setRGB(x, y, color);
                ++y;
            }
            ++x;
        }
        return mergedImg;
    }

    public static BufferedImage EdgesToImg(BufferedImage edges, int gaussianRadius, int color) {
        color = 0xFF000000 | color;
        int edgesW = edges.getWidth();
        int edgesH = edges.getHeight();
        int deltaSize = 4 + 2 * gaussianRadius;
        int imgW = edgesW + deltaSize;
        int imgH = edgesH + deltaSize;
        BufferedImage img = new BufferedImage(imgW, imgH, 2);
        int x = 0;
        while (x < imgW) {
            int y = 0;
            while (y < imgH) {
                int edgeColor;
                if (x >= deltaSize / 2 && x < edgesW + deltaSize / 2 && y >= deltaSize / 2 && y < edgesH + deltaSize / 2 && (edgeColor = edges.getRGB(x - deltaSize / 2, y - deltaSize / 2)) != -16777216) {
                    img.setRGB(x, y, color);
                }
                ++y;
            }
            ++x;
        }
        return img;
    }

    public static int[][][] RGBArray(BufferedImage img) {
        int[][][] rgb = null;
        int height = img.getHeight();
        int width = img.getWidth();
        if (height > 0 && width > 0) {
            rgb = new int[height][width][3];
            int row = 0;
            while (row < height) {
                int column = 0;
                while (column < width) {
                    rgb[row][column] = ImageUtils.intRGB(img.getRGB(column, row));
                    ++column;
                }
                ++row;
            }
        }
        return rgb;
    }

    public static BufferedImage RGBImg(int[][][] raw) {
        BufferedImage img = null;
        int height = raw.length;
        int width = raw[0].length;
        if (height > 0 && width > 0 || raw[0][0].length == 3) {
            img = new BufferedImage(width, height, 1);
            int row = 0;
            while (row < height) {
                int column = 0;
                while (column < width) {
                    img.setRGB(column, row, raw[row][column][0] << 16 | raw[row][column][1] << 8 | raw[row][column][2]);
                    ++column;
                }
                ++row;
            }
        }
        return img;
    }

    public static int[][] GSArray(BufferedImage img) {
        int[][] gs = null;
        int height = img.getHeight();
        int width = img.getWidth();
        if (height > 0 && width > 0) {
            gs = new int[height][width];
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    int bits = img.getRGB(j, i);
                    long avg = Math.round((double)((bits >> 16 & 0xFF) + (bits >> 8 & 0xFF) + (bits & 0xFF)) / 3.0);
                    gs[i][j] = (int)avg;
                    ++j;
                }
                ++i;
            }
        }
        return gs;
    }

    public static BufferedImage GSImg(int[][] raw) {
        BufferedImage img = null;
        int height = raw.length;
        int width = raw[0].length;
        if (height > 0 && width > 0) {
            img = new BufferedImage(width, height, 1);
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    img.setRGB(j, i, raw[i][j] << 16 | raw[i][j] << 8 | raw[i][j]);
                    ++j;
                }
                ++i;
            }
        }
        return img;
    }

    public static double[][][] HSVArray(BufferedImage img) {
        if (img == null) {
            throw new IllegalArgumentException("ERROR: Source image is null!");
        }
        int height = img.getHeight();
        int width = img.getWidth();
        double[][][] hsv = new double[height][width][];
        int r = 0;
        while (r < height) {
            int c = 0;
            while (c < width) {
                double cmin;
                double cmax;
                int[] rgb = ImageUtils.intRGB(img.getRGB(c, r));
                double[] rgbprime = new double[3];
                double[] pixelHSV = new double[3];
                int i = 0;
                while (i < 3) {
                    rgbprime[i] = (double)rgb[i] / 255.0;
                    ++i;
                }
                if (rgbprime[0] > rgbprime[1] && rgbprime[0] > rgbprime[2]) {
                    cmax = rgbprime[0];
                    cmin = rgbprime[1] < rgbprime[2] ? rgbprime[1] : rgbprime[2];
                    pixelHSV[0] = 60.0 * ((rgbprime[1] - rgbprime[2]) / (cmax - cmin) % 6.0);
                } else if (rgbprime[1] > rgbprime[0] && rgbprime[1] > rgbprime[2]) {
                    cmax = rgbprime[1];
                    cmin = rgbprime[0] < rgbprime[2] ? rgbprime[0] : rgbprime[2];
                    pixelHSV[0] = 60.0 * ((rgbprime[2] - rgbprime[0]) / (cmax - cmin) + 2.0);
                } else if (rgbprime[2] > rgbprime[1] && rgbprime[2] > rgbprime[0]) {
                    cmax = rgbprime[2];
                    cmin = rgbprime[0] < rgbprime[1] ? rgbprime[0] : rgbprime[1];
                    pixelHSV[0] = 60.0 * ((rgbprime[0] - rgbprime[1]) / (cmax - cmin) + 4.0);
                } else {
                    cmax = 0.0;
                    cmin = 0.0;
                    pixelHSV[0] = 0.0;
                }
                pixelHSV[1] = cmax == 0.0 ? 0.0 : (cmax - cmin) / cmax;
                pixelHSV[2] = cmax;
                hsv[r][c] = pixelHSV;
                ++c;
            }
            ++r;
        }
        return hsv;
    }

    public static double[][][] HSIArray(BufferedImage img) {
        if (img == null) {
            throw new IllegalArgumentException("ERROR: Source image is null!");
        }
        int height = img.getHeight();
        int width = img.getWidth();
        double[][][] hsi = new double[height][width][];
        double piRad = 57.29577951308232;
        int r = 0;
        while (r < height) {
            int c = 0;
            while (c < width) {
                int[] rgb = ImageUtils.intRGB(img.getRGB(c, r));
                double[] pixelHSI = new double[3];
                double cos1 = (double)rgb[0] - 0.5 * (double)rgb[1] - 0.5 * (double)rgb[2];
                double cos2 = Math.sqrt(rgb[0] * rgb[0] + rgb[1] * rgb[1] + rgb[2] * rgb[2] - rgb[0] * rgb[1] - rgb[0] * rgb[2] - rgb[1] * rgb[2]);
                pixelHSI[0] = Math.acos(cos1 / cos2) * piRad;
                if (rgb[1] < rgb[2]) {
                    pixelHSI[0] = 360.0 - pixelHSI[0];
                }
                pixelHSI[2] = (double)(rgb[0] + rgb[1] + rgb[2]) / 3.0;
                pixelHSI[1] = 1.0 - ImageUtils.Min(rgb[0], rgb[1], rgb[2]) / pixelHSI[2];
                hsi[r][c] = pixelHSI;
                ++c;
            }
            ++r;
        }
        return hsi;
    }

    public static double[][][] TSLArray(BufferedImage img) {
        if (img == null) {
            throw new IllegalArgumentException("ERROR: Source image is null!");
        }
        int height = img.getHeight();
        int width = img.getWidth();
        double[][][] tsl = new double[height][width][];
        int r = 0;
        while (r < height) {
            int c = 0;
            while (c < width) {
                int[] rgb = ImageUtils.intRGB(img.getRGB(c, r));
                double sum = rgb[0] + rgb[1] + rgb[2];
                double gPrime = (double)rgb[1] / sum;
                double[] pixelTSL = new double[]{gPrime > 0.1 ? Math.atan2((double)rgb[0] / sum, gPrime) / (Math.PI * 2) + 0.25 : (gPrime < -0.1 ? Math.atan2((double)rgb[0] / sum, gPrime) / (Math.PI * 2) + 0.75 : 0.0), Math.sqrt(1.8 * ((double)rgb[0] / sum - 0.3333) * ((double)rgb[0] / sum - 0.3333) + ((double)rgb[1] / sum - 0.3333) * ((double)rgb[1] / sum - 0.3333)), 0.299 * (double)rgb[0] + 0.587 * (double)rgb[1] + 0.114 * (double)rgb[2]};
                tsl[r][c] = pixelTSL;
                ++c;
            }
            ++r;
        }
        return tsl;
    }

    public static BufferedImage HSVImg(double[][][] raw) {
        int height = raw.length;
        int width = raw[0].length;
        if (height < 1 || width < 1 || raw[0][0].length != 3) {
            throw new IllegalArgumentException("ERROR: Malformed RGB array!");
        }
        BufferedImage img = new BufferedImage(width, height, 1);
        int r = 0;
        while (r < height) {
            int c = 0;
            while (c < width) {
                int[] rgb = new int[]{(int)raw[r][c][0] * 255, (int)raw[r][c][1] * 255, (int)(raw[r][c][2] / 360.0 * raw[r][c][2])};
                img.setRGB(c, r, rgb[0] << 16 | rgb[1] << 8 | rgb[2]);
                ++c;
            }
            ++r;
        }
        return img;
    }

    public static BufferedImage HSIImg(double[][][] raw) {
        int height = raw.length;
        int width = raw[0].length;
        if (height < 1 || width < 1 || raw[0][0].length != 3) {
            throw new IllegalArgumentException("ERROR: Malformed RGB array!");
        }
        BufferedImage img = new BufferedImage(width, height, 1);
        int r = 0;
        while (r < height) {
            int c = 0;
            while (c < width) {
                int[] rgb = new int[]{(int)raw[r][c][0] * 255, (int)raw[r][c][1] * 255, (int)(raw[r][c][2] / 360.0 * raw[r][c][2])};
                img.setRGB(c, r, rgb[0] << 16 | rgb[1] << 8 | rgb[2]);
                ++c;
            }
            ++r;
        }
        return img;
    }

    public static double[][][] YCbCrArray(BufferedImage img) {
        if (img == null) {
            throw new IllegalArgumentException("ERROR: Source image is null!");
        }
        int height = img.getHeight();
        int width = img.getWidth();
        double[][][] out = new double[height][width][3];
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                int[] rgb = ImageUtils.intRGB(img.getRGB(j, i));
                out[i][j][0] = 16.0 + (0.2568 * (double)rgb[0] + 0.5022 * (double)rgb[1] + 0.0975 * (double)rgb[2]);
                out[i][j][1] = 128.0 + (-0.1476 * (double)rgb[0] + -0.2899 * (double)rgb[1] + 0.4375 * (double)rgb[2]);
                out[i][j][2] = 128.0 + (0.4375 * (double)rgb[0] + -0.3663 * (double)rgb[1] + -0.0711 * (double)rgb[2]);
                ++j;
            }
            ++i;
        }
        return out;
    }

    private static int[] intRGB(int bits) {
        int[] rgb = new int[]{bits >> 16 & 0xFF, bits >> 8 & 0xFF, bits & 0xFF};
        int i = 0;
        while (i < 3) {
            if (rgb[i] < 0) {
                rgb[i] = 0;
            } else if (rgb[i] > 255) {
                rgb[i] = 255;
            }
            ++i;
        }
        return rgb;
    }

    private static double Min(int a, int b, int c) {
        if (a <= b && a <= c) {
            return a;
        }
        if (b <= c && b <= a) {
            return b;
        }
        return c;
    }
}

