/*
 * Decompiled with CFR 0.152.
 */
package image_processing.engine.canny;

public abstract class Gaussian {
    private static final double SQRT2PI = Math.sqrt(Math.PI * 2);

    public static int[][][] BlurRGB(int[][][] raw, int rad, double intens) {
        int chan;
        int chan2;
        int mr;
        double[] sum;
        int height = raw.length;
        int width = raw[0].length;
        double intensSquared2 = 2.0 * intens * intens;
        double invIntensSqrPi = 1.0 / (SQRT2PI * intens);
        double norm = 0.0;
        double[] mask = new double[2 * rad + 1];
        int[][][] outRGB = new int[height - 2 * rad][width - 2 * rad][3];
        int x = -rad;
        while (x < rad + 1) {
            double exp = Math.exp(-((double)(x * x) / intensSquared2));
            mask[x + rad] = invIntensSqrPi * exp;
            norm += mask[x + rad];
            ++x;
        }
        int r = rad;
        while (r < height - rad) {
            int c = rad;
            while (c < width - rad) {
                sum = new double[3];
                mr = -rad;
                while (mr < rad + 1) {
                    chan2 = 0;
                    while (chan2 < 3) {
                        int n = chan2;
                        sum[n] = sum[n] + mask[mr + rad] * (double)raw[r][c + mr][chan2];
                        ++chan2;
                    }
                    ++mr;
                }
                chan = 0;
                while (chan < 3) {
                    int n = chan;
                    sum[n] = sum[n] / norm;
                    outRGB[r - rad][c - rad][chan] = (int)Math.round(sum[chan]);
                    ++chan;
                }
                ++c;
            }
            ++r;
        }
        r = rad;
        while (r < height - rad) {
            int c = rad;
            while (c < width - rad) {
                sum = new double[3];
                mr = -rad;
                while (mr < rad + 1) {
                    chan2 = 0;
                    while (chan2 < 3) {
                        int n = chan2;
                        sum[n] = sum[n] + mask[mr + rad] * (double)raw[r + mr][c][chan2];
                        ++chan2;
                    }
                    ++mr;
                }
                chan = 0;
                while (chan < 3) {
                    int n = chan;
                    sum[n] = sum[n] / norm;
                    outRGB[r - rad][c - rad][chan] = (int)Math.round(sum[chan]);
                    ++chan;
                }
                ++c;
            }
            ++r;
        }
        return outRGB;
    }

    public static int[][] BlurGS(int[][] raw, int rad, double intens) {
        int mr;
        double sum;
        int height = raw.length;
        int width = raw[0].length;
        double norm = 0.0;
        double intensSquared2 = 2.0 * intens * intens;
        double invIntensSqrPi = 1.0 / (SQRT2PI * intens);
        double[] mask = new double[2 * rad + 1];
        int[][] outGS = new int[height - 2 * rad][width - 2 * rad];
        int x = -rad;
        while (x < rad + 1) {
            double exp = Math.exp(-((double)(x * x) / intensSquared2));
            mask[x + rad] = invIntensSqrPi * exp;
            norm += mask[x + rad];
            ++x;
        }
        int r = rad;
        while (r < height - rad) {
            int c = rad;
            while (c < width - rad) {
                sum = 0.0;
                mr = -rad;
                while (mr < rad + 1) {
                    sum += mask[mr + rad] * (double)raw[r][c + mr];
                    ++mr;
                }
                outGS[r - rad][c - rad] = (int)Math.round(sum /= norm);
                ++c;
            }
            ++r;
        }
        r = rad;
        while (r < height - rad) {
            int c = rad;
            while (c < width - rad) {
                sum = 0.0;
                mr = -rad;
                while (mr < rad + 1) {
                    sum += mask[mr + rad] * (double)raw[r + mr][c];
                    ++mr;
                }
                outGS[r - rad][c - rad] = (int)Math.round(sum /= norm);
                ++c;
            }
            ++r;
        }
        return outGS;
    }
}

