/*
 * Decompiled with CFR 0.152.
 */
package image_processing.engine;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Image {
    private final BufferedImage bufferedImg;
    private final int[][] pixels;

    public Image(File file) {
        int W = 0;
        int H = 0;
        BufferedImage img = new BufferedImage(1, 1, 2);
        try {
            img = ImageIO.read(file);
            W = img.getWidth();
            H = img.getHeight();
        }
        catch (IOException e) {
            System.err.println("Cannot open " + file.getAbsolutePath());
        }
        this.bufferedImg = img;
        this.pixels = new int[W][H];
        int x = 0;
        while (x < W) {
            this.bufferedImg.getRGB(x, 0, 1, H, this.pixels[x], 0, 1);
            ++x;
        }
    }

    public Image(BufferedImage bufferedImg) {
        this.bufferedImg = bufferedImg;
        if (bufferedImg != null) {
            int W = bufferedImg.getWidth();
            int H = bufferedImg.getHeight();
            this.pixels = new int[W][H];
            int x = 0;
            while (x < W) {
                bufferedImg.getRGB(x, 0, 1, H, this.pixels[x], 0, 1);
                ++x;
            }
        } else {
            this.pixels = new int[0][0];
        }
    }

    public int getPixel(int x, int y) {
        return this.pixels[x][y] & 0xFFFFFF;
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImg;
    }

    public int getWidth() {
        return this.bufferedImg != null ? this.bufferedImg.getWidth() : 0;
    }

    public int getHeight() {
        return this.bufferedImg != null ? this.bufferedImg.getHeight() : 0;
    }

    public void save(String name) {
        try {
            File file = new File(String.valueOf(name) + ".png");
            ImageIO.write((RenderedImage)this.bufferedImg, "png", file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

