/*
 * Decompiled with CFR 0.152.
 */
package image_processing.engine;

import common.engine.Utils;
import image_processing.enums.ColorSpace;
import java.util.Vector;

public class ColorPalette {
    private Vector<Integer> colors = new Vector();

    public void addColor(int color) {
        if (!this.colors.contains(color)) {
            this.colors.add(color);
        }
    }

    public int getNbColors() {
        return this.colors.size();
    }

    public Vector<Integer> getColors() {
        return this.colors;
    }

    public void addColorPalette(ColorPalette palette) {
        for (int color : palette.getColors()) {
            this.addColor(color);
        }
    }

    public int getClosestColor(int color, ColorSpace colorSpace) {
        int distMin = Utils.distanceBetweenColors(0, 0xFFFFFF, colorSpace);
        int closestColor = 0;
        for (int paletteColor : this.colors) {
            int dist = Utils.distanceBetweenColors(color, paletteColor, colorSpace);
            if (dist >= distMin) continue;
            closestColor = paletteColor;
            distMin = dist;
        }
        return closestColor;
    }

    public String toString() {
        String str = "[ColorPalette:\n";
        for (int color : this.colors) {
            str = String.valueOf(str) + "0x" + Integer.toHexString(color).toUpperCase() + ",\n";
        }
        return String.valueOf(str) + "]";
    }
}

