/*
 * Decompiled with CFR 0.152.
 */
package image_processing.engine;

import common.engine.Ink;
import common.engine.Jsonizable;
import common.engine.Utils;
import image_processing.engine.Brush;
import image_processing.engine.ColorPalette;
import image_processing.enums.ColorSpace;
import image_processing.enums.Setting;
import image_processing.session.Configuration;
import java.util.Comparator;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONObject;

public class BrushPalette
implements Jsonizable {
    private Vector<Brush> brushes = new Vector();

    public void addBrush(Brush brush) {
        if (this.getBrushByInputColor(brush.getInputColor()) == null) {
            this.brushes.add(brush);
        } else {
            System.err.println("BrushPalette already containing brush with input color 0x" + Integer.toHexString(brush.getInputColor()) + ", ignoring it (this should not happen)");
        }
    }

    public Brush getBrush(int index) {
        return this.brushes.get(index);
    }

    public Vector<Brush> getBrushes() {
        return this.brushes;
    }

    public Vector<Brush> getBrushesSortedByInputColor() {
        Vector sortedBrushs = (Vector)this.brushes.clone();
        sortedBrushs.sort(new Comparator<Brush>(){

            @Override
            public int compare(Brush o1, Brush o2) {
                ColorSpace colorSpace = Configuration.Instance.getCurrentSettings().getColorSpaceSetting(Setting.COLOR_SPACE);
                double graySaturationThreshold = Configuration.Instance.getCurrentSettings().getDoubleSetting(Setting.GREY_SATURATION_THRESHOLD);
                Ink ink1 = Utils.getClosestInk(o1.getInputColor(), colorSpace, graySaturationThreshold);
                Ink ink2 = Utils.getClosestInk(o2.getInputColor(), colorSpace, graySaturationThreshold);
                return ink1.getColorAsRgb() - ink2.getColorAsRgb();
            }
        });
        return sortedBrushs;
    }

    public int getNbBrushes() {
        return this.brushes.size();
    }

    public ColorPalette getInputColorPalette() {
        ColorPalette colorPalette = new ColorPalette();
        for (Brush brush : this.brushes) {
            colorPalette.addColor(brush.getInputColor());
        }
        return colorPalette;
    }

    public ColorPalette getOutputColorPalette() {
        ColorPalette colorPalette = new ColorPalette();
        colorPalette.addColor(0xFFFFFF);
        for (Brush brush : this.brushes) {
            if (brush.getInk() == null) continue;
            int color = brush.getInk().getColorAsRgb();
            colorPalette.addColor(color);
        }
        return colorPalette;
    }

    public Brush getBrushByInputColor(int inputColor) {
        for (Brush brush : this.brushes) {
            if (brush.getInputColor() != inputColor) continue;
            return brush;
        }
        return null;
    }

    public Vector<Brush> getBrushesOfInkColor(Ink ink) {
        Vector<Brush> brushsOfInkColor = new Vector<Brush>();
        for (Brush brush : this.brushes) {
            if (!brush.getInk().equals(ink)) continue;
            brushsOfInkColor.add(brush);
        }
        return brushsOfInkColor;
    }

    public String toString() {
        String str = "[BrushPalette:\n";
        for (Brush brush : this.brushes) {
            str = String.valueOf(str) + brush.toString() + ",\n";
        }
        return String.valueOf(str) + "]";
    }

    @Override
    public JSONObject toJSonObject() {
        JSONArray brushesJsonArray = new JSONArray();
        int idBrush = 0;
        while (idBrush < this.brushes.size()) {
            brushesJsonArray.put(idBrush, (Object)this.brushes.get(idBrush).toJSonObject());
            ++idBrush;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("brushes", (Object)brushesJsonArray);
        return jsonObject;
    }

    public static Jsonizable fromJsonObject(JSONObject jsonObject) {
        BrushPalette brushPalette = new BrushPalette();
        JSONArray brushesJsonArray = jsonObject.getJSONArray("brushes");
        int idBrush = 0;
        while (idBrush < brushesJsonArray.length()) {
            brushPalette.addBrush((Brush)Brush.fromJsonObject(brushesJsonArray.getJSONObject(idBrush)));
            ++idBrush;
        }
        return brushPalette;
    }
}

