/*
 * Decompiled with CFR 0.152.
 */
package image_processing.engine;

import common.engine.Ink;
import common.engine.Jsonizable;
import common.engine.Utils;
import org.json.JSONObject;

public class Brush
implements Jsonizable {
    private final int inputColor;
    private final int aimedOutputColor;
    private final Ink ink;
    private final double level;
    private final int angle;
    private final boolean fineOutliningEnabled;
    private final boolean thickOutliningEnabled;

    public Brush(int inputColor, Ink ink, double level, int angle, boolean fineOutliningEnabled, boolean thickOutliningEnabled) {
        this.inputColor = inputColor;
        this.ink = ink;
        if (level > 1.0) {
            System.err.println("level should be <=1");
            level = 1.0;
        }
        this.level = level;
        this.angle = angle;
        this.fineOutliningEnabled = fineOutliningEnabled;
        this.thickOutliningEnabled = thickOutliningEnabled;
        this.aimedOutputColor = ink != null ? Utils.getAimedColor(ink, level) : 0xFFFFFF;
    }

    public int getInputColor() {
        return this.inputColor;
    }

    public int getAimedOutputColor() {
        return this.aimedOutputColor;
    }

    public Ink getInk() {
        return this.ink;
    }

    public double getLevel() {
        return this.level;
    }

    public int getAngle() {
        return this.angle;
    }

    public boolean isFineOutliningEnabled() {
        return this.fineOutliningEnabled;
    }

    public boolean isThickOutliningEnabled() {
        return this.thickOutliningEnabled;
    }

    public Brush clone() {
        return new Brush(this.inputColor, this.ink, this.level, this.angle, this.fineOutliningEnabled, this.thickOutliningEnabled);
    }

    public String toString() {
        return "#" + Integer.toHexString(this.inputColor).toUpperCase() + "-" + this.ink.getName() + "-" + (int)Math.round(this.level * 100.0) + "percent";
    }

    @Override
    public JSONObject toJSonObject() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("inputColor", this.inputColor);
        jsonObject.put("ink", (Object)this.ink.getName());
        jsonObject.put("level", this.level);
        jsonObject.put("angle", this.angle);
        jsonObject.put("fineOutliningEnabled", this.fineOutliningEnabled);
        jsonObject.put("thickOutliningEnabled", this.thickOutliningEnabled);
        return jsonObject;
    }

    public static Jsonizable fromJsonObject(JSONObject jsonObject) {
        return new Brush(jsonObject.getInt("inputColor"), Ink.getAvailableInkByName(jsonObject.getString("ink")), jsonObject.getDouble("level"), jsonObject.getInt("angle"), jsonObject.getBoolean("fineOutliningEnabled"), jsonObject.getBoolean("thickOutliningEnabled"));
    }
}

