/*
 * Decompiled with CFR 0.152.
 */
package common.gui;

import image_processing.gui.StatusBar;
import image_processing.gui.Toolbox;
import image_processing.gui.TransformationResultView;
import image_processing.session.Project;
import image_processing.transformations.TransformationStep;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import streaming.gui.ControlBar;
import streaming.gui.ManualControlPanel;
import streaming.gui.PlotterView;
import streaming.gui.StreamingStatusBar;

public class Window
extends JFrame {
    private static final boolean OPEN_PLOTTER_VIEW_AT_STARTUP = false;
    public static Window Instance;
    private PlotterView plotterView;

    private Window() {
        Instance = this;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("Image To G-Code Tool", new ImageIcon("data/icons/drawing.png"), this.initEditorPanel());
        tabs.addTab("Plotter Controler", new ImageIcon("data/icons/plotter.png"), this.initStreamingPanel());
        tabs.setSelectedIndex(0);
        this.setTitle("The Plotter Project");
        this.setSize(1280, 1024);
        this.setLocationRelativeTo(null);
        this.setContentPane(tabs);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
    }

    private JPanel initEditorPanel() {
        JPanel editorPanel = new JPanel(new BorderLayout());
        JPanel views = new JPanel(new GridLayout(2, 3));
        views.add(new TransformationResultView("Source Image", Project.Instance.getTransformation(TransformationStep.IMAGE_IMPORT)));
        views.add(new TransformationResultView("Color-quantized Image", Project.Instance.getTransformation(TransformationStep.COLOR_QUANTIZATION)));
        views.add(new TransformationResultView("Recolored Image", Project.Instance.getTransformation(TransformationStep.RECOLORIZATION)));
        views.add(new TransformationResultView("Outlined Image", Project.Instance.getTransformation(TransformationStep.FINE_OUTLINING)));
        views.add(new TransformationResultView("Final Image", Project.Instance.getTransformation(TransformationStep.PATHS_GENERATION)));
        views.add(new TransformationResultView("Flying Motions", Project.Instance.getTransformation(TransformationStep.PATHS_OPTIMIZATION)));
        editorPanel.add((Component)views, "Center");
        editorPanel.add((Component)new Toolbox(), "East");
        editorPanel.add((Component)new StatusBar(), "South");
        return editorPanel;
    }

    private JPanel initStreamingPanel() {
        JPanel streamingPanel = new JPanel(new BorderLayout());
        streamingPanel.add((Component)new ControlBar(), "North");
        streamingPanel.add((Component)new ManualControlPanel(), "West");
        this.plotterView = new PlotterView();
        streamingPanel.add((Component)this.plotterView, "Center");
        streamingPanel.add((Component)new StreamingStatusBar(), "South");
        return streamingPanel;
    }

    public PlotterView getPlotterView() {
        return this.plotterView;
    }

    public static void main(String[] args) {
        Project.initProject();
        new Window();
    }
}

