/*
 * Decompiled with CFR 0.152.
 */
package common.gui;

import common.engine.Zoom;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class View
extends JPanel
implements MouseWheelListener,
MouseMotionListener {
    protected final JPanel viewPanel;
    protected final Zoom zoom;
    protected double previousMouseX;
    protected double previousMouseY;
    private double dragOriginX;
    private double dragOriginY;

    public View(String viewName, final Zoom zoom) {
        this.setBorder(BorderFactory.createTitledBorder(viewName));
        this.setLayout(new BorderLayout());
        this.zoom = zoom;
        this.viewPanel = new JPanel(){

            @Override
            public void paintComponent(Graphics G) {
                Graphics2D g = (Graphics2D)G;
                int W = this.getWidth();
                int H = this.getHeight();
                g.setColor(Color.white);
                g.fillRect(0, 0, W, H);
                g.setColor(Color.black);
                double zoomLevel = zoom.getZoomLevel();
                g.scale(zoomLevel, zoomLevel);
                g.translate(-zoom.getTranslationX(), -zoom.getTranslationY());
                View.this.paint(g, W, H);
                g.translate(zoom.getTranslationX(), zoom.getTranslationY());
                g.scale(1.0 / zoomLevel, 1.0 / zoomLevel);
            }
        };
        this.viewPanel.addMouseWheelListener(this);
        this.viewPanel.addMouseMotionListener(this);
        this.add((Component)this.viewPanel, "Center");
    }

    public View(String viewName) {
        this(viewName, new Zoom());
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        double previousZoom = this.zoom.getZoomLevel();
        double currentZoom = this.zoom.getZoomLevel();
        currentZoom = e.getUnitsToScroll() < 0 ? (currentZoom *= 1.1) : (currentZoom *= 0.9);
        double trX = this.zoom.getTranslationX();
        double trY = this.zoom.getTranslationY();
        double trMouseX = trX + (double)e.getX() / currentZoom;
        double trMouseY = trY + (double)e.getY() / currentZoom;
        trX = (int)(trMouseX + previousZoom / currentZoom * (trX - trMouseX));
        trY = (int)(trMouseY + previousZoom / currentZoom * (trY - trMouseY));
        this.zoom.setZoolLevelAndTranslation(currentZoom, trX, trY);
        this.getParent().repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isMiddleMouseButton(e)) {
            double trX = this.zoom.getTranslationX();
            double trY = this.zoom.getTranslationY();
            this.zoom.setTranslation(trX += (this.previousMouseX - (double)e.getX()) / this.zoom.getZoomLevel(), trY += (this.previousMouseY - (double)e.getY()) / this.zoom.getZoomLevel());
            this.previousMouseX = e.getX();
            this.previousMouseY = e.getY();
            this.getParent().repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.previousMouseX = e.getX();
        this.previousMouseY = e.getY();
    }

    protected double getZoomedMouseX(MouseEvent e) {
        return (double)e.getX() / this.zoom.getZoomLevel() + this.zoom.getTranslationX();
    }

    protected double getZoomedMouseY(MouseEvent e) {
        return (double)e.getY() / this.zoom.getZoomLevel() + this.zoom.getTranslationY();
    }

    protected abstract void paint(Graphics2D var1, int var2, int var3);
}

