/*
 * Decompiled with CFR 0.152.
 */
package common.engine;

import common.engine.Ink;
import common.enums.LabelType;
import image_processing.enums.ColorSpace;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;

public abstract class Utils {
    public static final int DISPLAY_DPI = 150;

    public static double pxToMm(int px, int dpi) {
        return (double)px * 25.4 / (double)dpi;
    }

    public static int mmToPx(double mm, int dpi) {
        return (int)Math.floor(mm * (double)dpi / 25.4);
    }

    public static double mmToPxDouble(double mm, int dpi) {
        return mm * (double)dpi / 25.4;
    }

    public static int distanceBetweenColors(int c0, int c1, ColorSpace colorSpace) {
        int r0 = (c0 & 0xFF0000) >> 16;
        int g0 = (c0 & 0xFF00) >> 8;
        int b0 = c0 & 0xFF;
        int r1 = (c1 & 0xFF0000) >> 16;
        int g1 = (c1 & 0xFF00) >> 8;
        int b1 = c1 & 0xFF;
        if (colorSpace == ColorSpace.RGB) {
            int R = Math.abs(r0 - r1);
            int G = Math.abs(g0 - g1);
            int B = Math.abs(b0 - b1);
            return R + G + B;
        }
        if (colorSpace == ColorSpace.SRGB) {
            double rm = (double)(r0 + r1) / 2.0;
            int R = (int)Math.pow(r0 - r1, 2.0);
            int G = (int)Math.pow(g0 - g1, 2.0);
            int B = (int)Math.pow(b0 - b1, 2.0);
            int d = (int)((2.0 + rm / 256.0) * (double)R + (double)(4 * G) + (2.0 + (255.0 - rm) / 256.0) * (double)B);
            return d;
        }
        if (colorSpace == ColorSpace.HUMAN_WEIGHTED) {
            int R = Math.abs(r0 - r1) * 30;
            int G = Math.abs(g0 - g1) * 59;
            int B = Math.abs(b0 - b1) * 11;
            return R + G + B;
        }
        System.err.println("Unknown color space");
        return 0;
    }

    public static Ink getClosestInk(int color, ColorSpace colorSpace, double graySaturationThreshold) {
        int r = (color & 0xFF0000) >> 16;
        int g = (color & 0xFF00) >> 8;
        int b = color & 0xFF;
        float[] hsb = new float[3];
        Color.RGBtoHSB(r, g, b, hsb);
        if ((double)hsb[1] < graySaturationThreshold) {
            return Ink.getBlackestAvailableInk();
        }
        int smallestDist = Integer.MAX_VALUE;
        Ink closestInk = null;
        for (Ink ink : Ink.getAvailableInks()) {
            int dist;
            if (ink == Ink.getBlackestAvailableInk() || (dist = Utils.distanceBetweenColors(color, ink.getColorAsRgb(), colorSpace)) >= smallestDist) continue;
            closestInk = ink;
            smallestDist = dist;
        }
        return closestInk;
    }

    public static int getAimedColor(Ink ink, double fillingLevel) {
        int rInk = ink.getR();
        int gInk = ink.getG();
        int bInk = ink.getB();
        int r = rInk + (int)Math.round((double)(255 - rInk) * (1.0 - fillingLevel));
        int g = gInk + (int)Math.round((double)(255 - gInk) * (1.0 - fillingLevel));
        int b = bInk + (int)Math.round((double)(255 - bInk) * (1.0 - fillingLevel));
        return r << 16 | g << 8 | b;
    }

    public static Stroke getPenStrokeInMm(double penWidthInMm) {
        return new BasicStroke((float)Utils.mmToPxDouble(penWidthInMm, 150), 1, 1);
    }

    public static Stroke getPenStrokeInPx(double penWidthInPx) {
        return new BasicStroke((float)penWidthInPx, 1, 1);
    }

    public static long factorial(int n) {
        long res = 1L;
        int i = 2;
        while (i <= n) {
            res *= (long)i;
            ++i;
        }
        return res;
    }

    public static int nChooseK(int n, int k) {
        return (int)(Utils.factorial(n) / (Utils.factorial(n - k) * Utils.factorial(k)));
    }

    public static double getSquaredDist(double x0, double y0, double x1, double y1) {
        return Math.pow(x1 - x0, 2.0) + Math.pow(y1 - y0, 2.0);
    }

    public static int[][] getCombinationsOfLength(Vector<Integer> values, int lengthOfCombinationsToKeep) {
        int[][] combinations = new int[Utils.nChooseK(values.size(), lengthOfCombinationsToKeep)][lengthOfCombinationsToKeep];
        int idCombination = 0;
        int i = 1;
        while ((double)i < Math.pow(2.0, values.size())) {
            ArrayList<Integer> combination = new ArrayList<Integer>();
            int j = 0;
            while (j < values.size()) {
                if (((long)i & (long)Math.pow(2.0, j)) > 0L) {
                    combination.add(values.get(j));
                }
                ++j;
            }
            if (combination.size() == lengthOfCombinationsToKeep) {
                int idValue = 0;
                while (idValue < combination.size()) {
                    combinations[idCombination][idValue] = (Integer)combination.get(idValue);
                    ++idValue;
                }
                ++idCombination;
            }
            ++i;
        }
        return combinations;
    }

    public static ImageIcon getColorIcon(Color color) {
        int w = 12;
        BufferedImage img = new BufferedImage(w, w, 2);
        Graphics g = img.getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, w, w);
        return new ImageIcon(img);
    }

    public static Color getLighterColor(Color c) {
        return new Color((510 + c.getRed()) / 3, (510 + c.getGreen()) / 3, (510 + c.getBlue()) / 3);
    }

    public static Color getBestForeground(Color backgroundColor) {
        return (backgroundColor.getRed() + backgroundColor.getGreen() + backgroundColor.getBlue()) / 3 >= 128 ? Color.WHITE : Color.BLACK;
    }

    public static String generateDoubleValuePerInkTooltip(HashMap<Ink, Double> valuesPerInk, LabelType labelType) {
        String tooltip = "<html>";
        for (Ink ink : Ink.getAvailableInks()) {
            if (!valuesPerInk.containsKey(ink)) continue;
            double value = valuesPerInk.get(ink);
            String beautifiedValue = String.valueOf(value);
            switch (labelType) {
                case DISTANCE: {
                    beautifiedValue = Utils.beautifyDistance(value);
                    break;
                }
                case DURATION: {
                    beautifiedValue = Utils.beautifyDuration(value);
                    break;
                }
                case DURATION_AS_CLOCK: {
                    beautifiedValue = Utils.beautifyDurationAsClock(value);
                }
            }
            tooltip = String.valueOf(tooltip) + String.format(Locale.US, "<span style='color:%s'>%s for %s ink</span><br/>", ink.getColorAsHexString(), beautifiedValue, ink.getName());
        }
        tooltip = String.valueOf(tooltip) + "</html>";
        return tooltip;
    }

    public static String generateIntValuePerInkTooltip(HashMap<Ink, Integer> valuesPerInk, LabelType labelType) {
        HashMap<Ink, Double> doubleValuesPerInk = new HashMap<Ink, Double>();
        for (Map.Entry<Ink, Integer> entry : valuesPerInk.entrySet()) {
            doubleValuesPerInk.put(entry.getKey(), (double)entry.getValue());
        }
        return Utils.generateDoubleValuePerInkTooltip(doubleValuesPerInk, labelType);
    }

    public static String generateDoubleProgressionPerInkTooltip(HashMap<Ink, Double> currentValuesPerInk, HashMap<Ink, Double> valuesMaxPerInk, LabelType labelType) {
        String tooltip = "<html>";
        for (Ink ink : Ink.getAvailableInks()) {
            if (!currentValuesPerInk.containsKey(ink)) continue;
            String beautifiedValue = Utils.beautifyProgression(currentValuesPerInk.get(ink), valuesMaxPerInk.get(ink), labelType);
            tooltip = String.valueOf(tooltip) + String.format(Locale.US, "<span style='color:%s'>%s for %s ink</span><br/>", ink.getColorAsHexString(), beautifiedValue, ink.getName());
        }
        tooltip = String.valueOf(tooltip) + "</html>";
        return tooltip;
    }

    public static String generateIntProgressionPerInkTooltip(HashMap<Ink, Integer> currentValuesPerInk, HashMap<Ink, Integer> valuesMaxPerInk, LabelType labelType) {
        HashMap<Ink, Double> doubleCurrentValuesPerInk = new HashMap<Ink, Double>();
        HashMap<Ink, Double> doubleValuesMaxPerInk = new HashMap<Ink, Double>();
        for (Ink ink : currentValuesPerInk.keySet()) {
            doubleCurrentValuesPerInk.put(ink, (double)currentValuesPerInk.get(ink));
            doubleValuesMaxPerInk.put(ink, (double)valuesMaxPerInk.get(ink));
        }
        return Utils.generateDoubleProgressionPerInkTooltip(doubleCurrentValuesPerInk, doubleValuesMaxPerInk, labelType);
    }

    public static String beautifyDistance(double distanceInMm) {
        if (distanceInMm < 1000.0) {
            return String.format(Locale.US, "%.0fmm", distanceInMm);
        }
        return String.format(Locale.US, "%.1fm", distanceInMm / 1000.0);
    }

    public static String beautifyDuration(double durationInS) {
        if (durationInS < 60.0) {
            return String.format(Locale.US, "%.0fs", durationInS);
        }
        if (durationInS < 3600.0) {
            return String.format(Locale.US, "%dmn %ds", (int)(durationInS / 60.0), (int)(durationInS % 60.0));
        }
        return String.format(Locale.US, "%dh %dmn %ds", (int)(durationInS / 3600.0), (int)(durationInS % 3600.0 / 60.0), (int)(durationInS % 60.0));
    }

    public static String beautifyDurationAsClock(double durationInS) {
        return String.format(Locale.US, "%d:%02d:%02d", (int)durationInS / 3600, (int)(durationInS % 3600.0) / 60, (int)durationInS % 60);
    }

    public static String beautifyProgression(double currentValue, double maxValue, LabelType labelType) {
        switch (labelType) {
            case DISTANCE: {
                return String.format(Locale.US, "%s/%s", Utils.beautifyDistance(currentValue), Utils.beautifyDistance(maxValue));
            }
        }
        return String.format(Locale.US, "%.0f/%.0f", currentValue, maxValue);
    }

    public static String readFile(File file) throws IOException {
        String line;
        String content = "";
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            content = String.valueOf(content) + line + "\n";
        }
        reader.close();
        return content;
    }

    public static double computeXYZTravelDuration(double x0, double y0, double z0, double x1, double y1, double z1, double accelXY, double speedMaxXY, double accelZ, double speedMaxZ, boolean coreXyDesign) {
        double distY;
        double distX;
        if (coreXyDesign) {
            double angle = Math.atan2(Math.abs(y1 - y0), Math.abs(x1 - x0));
            double alpha = Math.cos(angle - 0.7853981633974483);
            distX = Math.abs(x1 - x0) / alpha + Math.abs(y1 - y0) / alpha;
            distY = 0.0;
            speedMaxXY /= alpha;
        } else {
            distX = Math.abs(x1 - x0);
            distY = Math.abs(y1 - y0);
        }
        double distZ = Math.abs(z1 - z0);
        double distanceToReachMaxXYSpeed = 0.5 / accelXY * speedMaxXY * speedMaxXY;
        double durationX = distX < 2.0 * distanceToReachMaxXYSpeed ? 2.0 * Math.sqrt(distX / accelXY) : 2.0 * speedMaxXY / accelXY + (distX - 2.0 * distanceToReachMaxXYSpeed) / speedMaxXY;
        double durationY = distY < 2.0 * distanceToReachMaxXYSpeed ? 2.0 * Math.sqrt(distY / accelXY) : 2.0 * speedMaxXY / accelXY + (distY - 2.0 * distanceToReachMaxXYSpeed) / speedMaxXY;
        double distanceToReachMaxZSpeed = 0.5 / accelZ * speedMaxZ * speedMaxZ;
        double durationZ = distZ < 2.0 * distanceToReachMaxZSpeed ? 2.0 * Math.sqrt(distZ / accelZ) : 2.0 * speedMaxZ / accelZ + (distZ - 2.0 * distanceToReachMaxZSpeed) / speedMaxZ;
        return Math.max(durationX, Math.max(durationY, durationZ));
    }

    public static double computeXYTravelDuration(double x0, double y0, double x1, double y1, double accel, double speedMax, boolean coreXyDesign) {
        return Utils.computeXYZTravelDuration(x0, y0, 0.0, x1, y1, 0.0, accel, speedMax, 1.0, 1.0, coreXyDesign);
    }

    public static double computeZTravelDuration(double z0, double z1, double accel, double speedMax, boolean coreXyDesign) {
        return Utils.computeXYZTravelDuration(0.0, 0.0, z0, 0.0, 0.0, z1, 1.0, 1.0, accel, speedMax, coreXyDesign);
    }

    public static double speedToFeedrate(double speed, boolean isCoreXy) {
        double feedrate = speed * 60.0;
        if (isCoreXy) {
            feedrate /= Math.cos(0.7853981633974483);
        }
        return feedrate;
    }
}

