/*
 * Decompiled with CFR 0.152.
 */
package common.engine;

import image_processing.engine.BrushPalette;
import image_processing.enums.ColorAttributionMethod;
import image_processing.enums.ColorQuantizationMethod;
import image_processing.enums.ColorSpace;
import image_processing.enums.OutputMirroring;
import image_processing.enums.OutputPosition;
import image_processing.enums.OutputRotation;
import image_processing.enums.Setting;
import java.io.File;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class SettingsSet
implements Cloneable {
    private final JSONObject settings;

    public SettingsSet(JSONObject settings) {
        this.settings = new JSONObject(settings.toString());
    }

    public boolean has(Setting setting) {
        return this.settings.has(setting.getName());
    }

    public Set<String> getSettingsNames() {
        return this.settings.keySet();
    }

    public String getStringSetting(Setting setting) {
        String value = this.settings.getString(setting.getName());
        return value != null ? value : "";
    }

    public File getFileSetting(Setting setting) {
        return this.settings.has(setting.getName()) ? new File(this.settings.getString(setting.getName())) : null;
    }

    public int getIntSetting(Setting setting) {
        return this.settings.has(setting.getName()) ? this.settings.getInt(setting.getName()) : 0;
    }

    public double getDoubleSetting(Setting setting) {
        return this.settings.has(setting.getName()) ? this.settings.getDouble(setting.getName()) : 0.0;
    }

    public boolean getBoolSetting(Setting setting) {
        return this.settings.has(setting.getName()) ? this.settings.getBoolean(setting.getName()) : false;
    }

    public ColorSpace getColorSpaceSetting(Setting setting) {
        return ColorSpace.values()[this.getIntSetting(setting)];
    }

    public ColorQuantizationMethod getColorQuantizationMethodSetting(Setting setting) {
        return ColorQuantizationMethod.values()[this.getIntSetting(setting)];
    }

    public ColorAttributionMethod getColorAttributionMethodSetting(Setting setting) {
        return ColorAttributionMethod.values()[this.getIntSetting(setting)];
    }

    public OutputRotation getOutputRotationSetting(Setting setting) {
        return OutputRotation.values()[this.getIntSetting(setting)];
    }

    public OutputPosition getOutputPositionSetting(Setting setting) {
        return OutputPosition.values()[this.getIntSetting(setting)];
    }

    public OutputMirroring getOutputMirroringSetting(Setting setting) {
        return OutputMirroring.values()[this.getIntSetting(setting)];
    }

    public BrushPalette getSelectedBrushPalette() {
        return this.getBrushPalettesSetting(Setting.BRUSH_PALETTES)[this.getIntSetting(Setting.ID_SELECTED_BRUSH_PALETTE)];
    }

    public BrushPalette[] getBrushPalettesSetting(Setting setting) {
        if (!this.settings.has(setting.getName())) {
            return null;
        }
        JSONArray brushPalettesJsonArray = this.settings.getJSONArray(setting.getName());
        BrushPalette[] brushPalettes = new BrushPalette[brushPalettesJsonArray.length()];
        int idBrushPalette = 0;
        while (idBrushPalette < brushPalettesJsonArray.length()) {
            brushPalettes[idBrushPalette] = (BrushPalette)BrushPalette.fromJsonObject(brushPalettesJsonArray.getJSONObject(idBrushPalette));
            ++idBrushPalette;
        }
        return brushPalettes;
    }

    public String toString() {
        return String.format("[SettingsSet: %s]", this.settings.toString());
    }

    public Object clone() {
        return new SettingsSet(this.settings);
    }
}

