/*
 * Decompiled with CFR 0.152.
 */
package common.engine;

import common.engine.Line;
import common.engine.Utils;
import java.util.ArrayList;
import java.util.Collections;
import streaming.enums.PlotterSetting;
import streaming.session.PlotterConfiguration;

public class Path
implements Cloneable {
    public static final boolean USE_FLYING_DURATION_AS_COST = true;
    private ArrayList<Line> lines;
    private final double zClearHeight;
    private double flyingDistance;
    private double squaredFlyingDistance;
    private double flyingDuration;
    private double drawingDistance;
    private double drawingDuration;
    private double upDownDistance;
    private double upDownDuration;
    private boolean shouldRecomputeDistancesAndDurations = true;

    public Path(ArrayList<Line> lines, double zClearHeight) {
        this.lines = lines;
        this.zClearHeight = zClearHeight;
    }

    public Path(double zClearHeight) {
        this(new ArrayList<Line>(), zClearHeight);
    }

    public double getZClearHeight() {
        return this.zClearHeight;
    }

    public ArrayList<Line> getLines() {
        return this.lines;
    }

    public void addLine(Line line) {
        this.lines.add(line);
        this.shouldRecomputeDistancesAndDurations = true;
    }

    public void removeLine(int id) {
        this.lines.remove(id);
        this.shouldRecomputeDistancesAndDurations = true;
    }

    public Line getLine(int id) {
        return this.lines.get(id);
    }

    public void setLine(int id, Line line) {
        this.lines.set(id, line);
        this.shouldRecomputeDistancesAndDurations = true;
    }

    public int getNbLines() {
        return this.lines.size();
    }

    public int getIndexInPath(Line line) {
        int id = this.lines.indexOf(line);
        if (id == -1) {
            id = this.lines.indexOf(Line.createInvertedLine(line));
        } else {
            int idInverted = this.lines.indexOf(Line.createInvertedLine(line));
            if (idInverted != -1 && idInverted < id) {
                id = idInverted;
            }
        }
        return id;
    }

    private void recomputeDistancesAndDurations() {
        this.squaredFlyingDistance = 0.0;
        this.flyingDistance = 0.0;
        int i = 1;
        while (i < this.lines.size()) {
            Line line0 = this.lines.get(i - 1);
            Line line1 = this.lines.get(i);
            this.squaredFlyingDistance += line1.getCostFrom(line0);
            this.flyingDistance += line1.getFlyingDistanceTo(line0);
            ++i;
        }
        this.drawingDistance = 0.0;
        for (Line line : this.lines) {
            this.drawingDistance += Math.sqrt(Math.pow(line.x1 - line.x0, 2.0) + Math.pow(line.y1 - line.y0, 2.0));
        }
        this.upDownDistance = (double)(2 * this.lines.size()) * this.zClearHeight;
        double zClearDuration = Utils.computeZTravelDuration(0.0, this.zClearHeight, PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.Z_ACCELERATION), PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.Z_MAX_SPEED), PlotterConfiguration.Instance.getBooleanSettingValue(PlotterSetting.IS_CORE_XY));
        this.upDownDuration = zClearDuration * 2.0;
        this.drawingDuration = 0.0;
        this.flyingDuration = 0.0;
        double lastX = Double.MAX_VALUE;
        double lastY = Double.MAX_VALUE;
        int idLine = 0;
        while (idLine < this.lines.size()) {
            Line line = this.lines.get(idLine);
            if (idLine > 0 && (line.x0 != lastX || line.y0 != lastY)) {
                this.flyingDuration += Utils.computeXYTravelDuration(lastX, lastY, line.x0, line.y0, PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.XY_ACCELERATION), PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.FLYING_XY_MAX_SPEED), PlotterConfiguration.Instance.getBooleanSettingValue(PlotterSetting.IS_CORE_XY));
                this.upDownDuration += zClearDuration * 2.0;
            }
            this.drawingDuration += Utils.computeXYTravelDuration(line.x0, line.y0, line.x1, line.y1, PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.XY_ACCELERATION), PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.DRAWING_XY_MAX_SPEED), PlotterConfiguration.Instance.getBooleanSettingValue(PlotterSetting.IS_CORE_XY));
            lastX = line.x1;
            lastY = line.y1;
            ++idLine;
        }
        this.shouldRecomputeDistancesAndDurations = false;
    }

    private double getSquaredFlyingDistance() {
        if (this.shouldRecomputeDistancesAndDurations) {
            this.recomputeDistancesAndDurations();
        }
        return this.squaredFlyingDistance;
    }

    public double getCost() {
        return this.getFlyingDuration();
    }

    public double getFitness() {
        return 1.0 / this.getCost();
    }

    public double getFlyingDistance() {
        if (this.shouldRecomputeDistancesAndDurations) {
            this.recomputeDistancesAndDurations();
        }
        return this.flyingDistance;
    }

    public double getFlyingAndUpDownDistance() {
        if (this.shouldRecomputeDistancesAndDurations) {
            this.recomputeDistancesAndDurations();
        }
        return this.flyingDistance + this.upDownDistance;
    }

    public double getUpDownDistance() {
        if (this.shouldRecomputeDistancesAndDurations) {
            this.recomputeDistancesAndDurations();
        }
        return this.upDownDistance;
    }

    public double getDrawingDistance() {
        if (this.shouldRecomputeDistancesAndDurations) {
            this.recomputeDistancesAndDurations();
        }
        return this.drawingDistance;
    }

    public double getDrawingDuration() {
        if (this.shouldRecomputeDistancesAndDurations) {
            this.recomputeDistancesAndDurations();
        }
        return this.drawingDuration;
    }

    public double getFlyingDuration() {
        if (this.shouldRecomputeDistancesAndDurations) {
            this.recomputeDistancesAndDurations();
        }
        return this.flyingDuration;
    }

    public double getFlyingAndUpDownDuration() {
        if (this.shouldRecomputeDistancesAndDurations) {
            this.recomputeDistancesAndDurations();
        }
        return this.flyingDuration + this.upDownDuration;
    }

    public double getTotalDuration() {
        if (this.shouldRecomputeDistancesAndDurations) {
            this.recomputeDistancesAndDurations();
        }
        return this.drawingDuration + this.flyingDuration + this.upDownDuration;
    }

    public Path convertFromPxToMm(int dpi) {
        Path convertedPath = new Path(this.zClearHeight);
        for (Line line : this.lines) {
            convertedPath.addLine(new Line(Utils.pxToMm((int)line.x0, dpi), Utils.pxToMm((int)line.y0, dpi), Utils.pxToMm((int)line.x1, dpi), Utils.pxToMm((int)line.y1, dpi)));
        }
        return convertedPath;
    }

    public Object clone() throws CloneNotSupportedException {
        return new Path((ArrayList)this.lines.clone(), this.zClearHeight);
    }

    public String toString() {
        String str = "[Path: ";
        for (Line line : this.lines) {
            str = String.valueOf(str) + (line != null ? line.toString() : null) + " ";
        }
        return String.valueOf(str) + "]";
    }

    public static Path optimizeLinesDirections(Path path) {
        Path optimizedPath = new Path(path.zClearHeight);
        Line lastLine = path.lines.get(0);
        optimizedPath.addLine(lastLine);
        int i = 1;
        while (i < path.lines.size()) {
            Line line = path.lines.get(i);
            Line invertedLine = Line.createInvertedLine(line);
            double d0 = line.getCostFrom(lastLine);
            double d1 = invertedLine.getCostFrom(lastLine);
            if (d1 < d0) {
                optimizedPath.addLine(invertedLine);
                lastLine = invertedLine;
            } else {
                optimizedPath.addLine(line);
                lastLine = line;
            }
            ++i;
        }
        return optimizedPath;
    }

    public static Path getShuffledCopy(Path path) {
        ArrayList lines = (ArrayList)path.getLines().clone();
        Collections.shuffle(lines);
        return new Path(lines, path.getZClearHeight());
    }
}

