/*
 * Decompiled with CFR 0.152.
 */
package common.engine;

import common.engine.Utils;
import image_processing.enums.OutputMirroring;
import java.util.Locale;
import streaming.enums.PlotterSetting;
import streaming.session.PlotterConfiguration;

public class Line
implements Cloneable {
    public final double x0;
    public final double y0;
    public final double x1;
    public final double y1;

    public Line(double x0, double y0, double x1, double y1) {
        this(x0, y0, x1, y1, false);
    }

    public Line(double x0, double y0, double x1, double y1, boolean invertDirection) {
        if (!invertDirection) {
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
        } else {
            this.x0 = x1;
            this.y0 = y1;
            this.x1 = x0;
            this.y1 = y0;
        }
    }

    public double getSquaredFlyingDistanceTo(Line other) {
        return Math.pow(other.x0 - this.x1, 2.0) + Math.pow(other.y0 - this.y1, 2.0);
    }

    public double getCostFrom(Line other) {
        return Utils.computeXYTravelDuration(this.x0, this.y0, other.x1, other.y1, PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.XY_ACCELERATION), PlotterConfiguration.Instance.getDoubleSettingValue(PlotterSetting.FLYING_XY_MAX_SPEED), PlotterConfiguration.Instance.getBooleanSettingValue(PlotterSetting.IS_CORE_XY));
    }

    public double getSquaredLength() {
        return Math.pow(this.x1 - this.x0, 2.0) + Math.pow(this.y1 - this.y0, 2.0);
    }

    public double getFlyingDistanceTo(Line other) {
        return Math.sqrt(this.getSquaredFlyingDistanceTo(other));
    }

    public boolean isAlignedWith(Line other) {
        return (other.y0 - this.y1) * (this.x0 - other.x0) - (this.y0 - other.y0) * (other.x0 - this.x1) == 0.0 && (other.y1 - this.y1) * (this.x0 - other.x1) - (this.y0 - other.y1) * (other.x1 - this.x1) == 0.0;
    }

    public boolean equals(Object o) {
        if (o instanceof Line) {
            Line l = (Line)o;
            return this.x0 == l.x0 && this.y0 == l.y0 && this.x1 == l.x1 && this.y1 == l.y1;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + new Double(this.x0).hashCode();
        hash = 31 * hash + new Double(this.y0).hashCode();
        hash = 31 * hash + new Double(this.x1).hashCode();
        hash = 31 * hash + new Double(this.y1).hashCode();
        return hash;
    }

    public String toString() {
        return String.format(Locale.US, "[Line (%f;%f) -> (%f;%f)]", this.x0, this.y0, this.x1, this.y1);
    }

    public Object clone() throws CloneNotSupportedException {
        return new Line(this.x0, this.y0, this.x1, this.y1);
    }

    public static Line createInvertedLine(Line line) {
        return new Line(line.x1, line.y1, line.x0, line.y0);
    }

    public static Line createRotatedLine(Line line, int angle, double rX, double rY) {
        double a = Math.toRadians(angle);
        double X0 = rX + (line.x0 - rX) * Math.cos(a) - (line.y0 - rY) * Math.sin(a);
        double Y0 = rY + (line.x0 - rX) * Math.sin(a) + (line.y0 - rY) * Math.cos(a);
        double X1 = rX + (line.x1 - rX) * Math.cos(a) - (line.y1 - rY) * Math.sin(a);
        double Y1 = rY + (line.x1 - rX) * Math.sin(a) + (line.y1 - rY) * Math.cos(a);
        return new Line(X0, Y0, X1, Y1);
    }

    public static Line createTranslatedLine(Line line, double trX, double trY) {
        return new Line(line.x0 + trX, line.y0 + trY, line.x1 + trX, line.y1 + trY);
    }

    public static Line createMirroredLine(Line line, OutputMirroring mirroring, double xMax, double yMax) {
        double X0 = line.x0;
        double Y0 = line.y0;
        double X1 = line.x1;
        double Y1 = line.y1;
        if (mirroring.xMirroring()) {
            X0 = xMax - X0;
            X1 = xMax - X1;
        }
        if (mirroring.yMirroring()) {
            Y0 = yMax - Y0;
            Y1 = yMax - Y1;
        }
        return new Line(X0, Y0, X1, Y1);
    }
}

