/*
 * Decompiled with CFR 0.152.
 */
package common.engine;

import common.engine.Jsonizable;
import common.engine.Utils;
import image_processing.enums.ColorSpace;
import java.awt.Color;
import java.util.Vector;
import org.json.JSONObject;

public class Ink
implements Jsonizable {
    private static Vector<Ink> availableInks = new Vector();
    private static Ink blackestAvailableInk;
    private String name;
    private int color;

    private Ink(String name, int color) {
        this.name = name;
        this.color = color;
    }

    public String getName() {
        return this.name;
    }

    public Color getColor() {
        return new Color(this.color);
    }

    public int getColorAsRgb() {
        return this.color;
    }

    public String getColorAsHexString() {
        return "#" + Integer.toHexString(this.color).toUpperCase();
    }

    public int getR() {
        return this.color >> 16 & 0xFF;
    }

    public int getG() {
        return this.color >> 8 & 0xFF;
    }

    public int getB() {
        return this.color & 0xFF;
    }

    public boolean isBlackestAvailableInk() {
        return this.equals(blackestAvailableInk);
    }

    public boolean equals(Object o) {
        if (o instanceof Ink) {
            Ink other = (Ink)o;
            return this.color == other.color;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + new Integer(this.color).hashCode();
        hash = 31 * hash + this.name.hashCode();
        return hash;
    }

    public String toString() {
        return String.format("[Ink: %s (%s)%s]", this.name, this.getColorAsHexString(), this.isBlackestAvailableInk() ? " (blackest ink available)" : "");
    }

    public static boolean registerNewAvailableInk(Ink ink) {
        for (Ink availableInk : availableInks) {
            if (availableInk.getColor() != ink.getColor()) continue;
            return false;
        }
        availableInks.add(ink);
        int blackestInkDistanceToAbsoluteBlack = blackestAvailableInk != null ? Utils.distanceBetweenColors(0, blackestAvailableInk.getColorAsRgb(), ColorSpace.RGB) : Integer.MAX_VALUE;
        int inkDistanceToAbsoluteBlack = Utils.distanceBetweenColors(0, ink.getColorAsRgb(), ColorSpace.RGB);
        if (inkDistanceToAbsoluteBlack < blackestInkDistanceToAbsoluteBlack) {
            blackestAvailableInk = ink;
        }
        return true;
    }

    public static int getNbAvailableInks() {
        return availableInks.size();
    }

    public static Vector<Ink> getAvailableInks() {
        return availableInks;
    }

    public static Ink getBlackestAvailableInk() {
        return blackestAvailableInk;
    }

    public static Ink getAvailableInkByColor(int color) {
        for (Ink inkColor : availableInks) {
            if (inkColor.color != color) continue;
            return inkColor;
        }
        return null;
    }

    public static Ink getAvailableInkByName(String name) {
        for (Ink inkColor : availableInks) {
            if (!inkColor.name.equals(name)) continue;
            return inkColor;
        }
        return null;
    }

    @Override
    public JSONObject toJSonObject() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)this.name);
        jsonObject.put("color", (Object)this.getColorAsHexString());
        return jsonObject;
    }

    public static Jsonizable fromJsonObject(JSONObject jsonObject) {
        return new Ink(jsonObject.getString("name"), Integer.parseInt(jsonObject.getString("color").substring(1), 16));
    }
}

