/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.util.Vector;

public class Island {
    private int x = 0;
    private int y = 0;
    private Path2D path;
    private Vector<Point> points;
    private int idPlayer = -1;
    private Atoll atoll;
    private int radius;
    private int units = 1;
    private String name;
    private Vector<Island> reachablesIslands = new Vector();
    private boolean tryReach;
    private boolean tryTransfer;

    public Island(int radius) {
        this.radius = radius;
        if (Screen.largerIsland == null || radius > Screen.largerIsland.getRadius()) {
            Screen.largerIsland = this;
        }
        int nb = (int)(2.0 + Math.random() * 5.0) * 2;
        this.points = new Vector();
        int i = 0;
        while (i < nb) {
            double dist = (double)(radius * 1 / 3) + Math.random() * (double)(radius * 2 / 3);
            if (i % 2 == 1) {
                dist = Math.min((double)radius, dist * 1.5);
            }
            Point p = Screen.distDir(dist, ((double)i - 0.5 + Math.random()) * 360.0 / (double)nb);
            this.points.add(p);
            ++i;
        }
        this.points.add(this.points.get(0));
        ++nb;
        this.path = new Path2D.Double();
        i = 0;
        while (i < nb) {
            Point p = this.points.get(i);
            if (i == 0) {
                this.path.moveTo(p.x, p.y);
            } else {
                Point lastP = this.points.get(i - 1);
                if (i % 2 == 0) {
                    this.path.quadTo(lastP.x, lastP.y, p.x, p.y);
                }
            }
            ++i;
        }
        this.createName();
    }

    public void attack(Island is) {
        while (this.units > 1 && is.getUnits() > 0) {
            Vector<Integer> desAtt = new Vector<Integer>();
            Vector<Integer> desDef = new Vector<Integer>();
            int i = 0;
            while (i < Math.min(3, this.units - 1)) {
                desAtt.add((int)Math.ceil(Math.random() * 6.0));
                ++i;
            }
            desDef.add((int)Math.ceil(Math.random() * 6.0));
            if (is.getUnits() > 1) {
                desDef.add((int)Math.ceil(Math.random() * 6.0));
            }
            int maxAtt = 0;
            int minAtt = 6;
            int totAtt = 0;
            int middAtt = 0;
            int i2 = 0;
            while (i2 < desAtt.size()) {
                maxAtt = Math.max(maxAtt, (Integer)desAtt.get(i2));
                minAtt = Math.min(minAtt, (Integer)desAtt.get(i2));
                totAtt += ((Integer)desAtt.get(i2)).intValue();
                ++i2;
            }
            middAtt = totAtt - maxAtt - minAtt;
            if (middAtt == 0) {
                middAtt = minAtt;
            }
            int maxDef = Math.max((Integer)desDef.get(0), (Integer)desDef.get(desDef.size() - 1));
            boolean conquis = false;
            conquis = maxAtt > maxDef ? (conquis |= is.destroyUnit(this)) : (conquis |= this.destroyUnit(is));
            if (desDef.size() > 1 && this.units > 1) {
                conquis = middAtt > Math.min((Integer)desDef.get(0), (Integer)desDef.get(1)) ? (conquis |= is.destroyUnit(this)) : (conquis |= this.destroyUnit(is));
            }
            if (!conquis) continue;
            return;
        }
    }

    private void createName() {
        String[] syllabes = new String[]{"af", "al", "am", "an", "at", "ef", "el", "em", "en", "ep", "es", "et", "id", "if", "il", "im", "in", "is", "it", "od", "of", "ol", "om", "on", "op", "or", "os", "ul", "um", "un", "up", "ur", "us", "ut"};
        this.name = "";
        int i = 0;
        while (i < 3) {
            this.name = String.valueOf(this.name) + syllabes[(int)(Math.random() * (double)syllabes.length)];
            ++i;
        }
        this.name = String.valueOf(String.valueOf(this.name.charAt(0)).toUpperCase()) + this.name.substring(1, this.name.length());
    }

    public Path2D getShape(boolean translated) {
        Path2D path = (Path2D)this.path.clone();
        if (translated) {
            path.transform(AffineTransform.getTranslateInstance(this.x, this.y));
        }
        return path;
    }

    public boolean destroyUnit(Island from) {
        --this.units;
        if (this.units == 0) {
            this.idPlayer = from.getIdPlayer();
            this.units = from.units - 1;
            from.setUnits(1);
            return true;
        }
        return false;
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Point getPos() {
        return new Point(this.x, this.y);
    }

    public int getRadius() {
        return this.radius;
    }

    public Atoll getAtoll() {
        return this.atoll;
    }

    public void setAtoll(Atoll at) {
        this.atoll = at;
    }

    public boolean isCollision() {
        int i = 0;
        while (i < Screen.islands.size()) {
            Area me = new Area(this.getShape(true));
            Area other = new Area(Screen.islands.get(i).getShape(true));
            me.intersect(other);
            if (!me.isEmpty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Color getPlayerColor(int id) {
        switch (id) {
            case -1: {
                return Color.lightGray;
            }
            case 0: {
                return new Color(160, 82, 13);
            }
            case 1: {
                return new Color(106, 90, 205);
            }
            case 2: {
                return new Color(255, 215, 0);
            }
            case 3: {
                return new Color(50, 205, 50);
            }
            case 4: {
                return new Color(205, 92, 92);
            }
            case 5: {
                return new Color(30, 144, 255);
            }
            case 6: {
                return new Color(255, 218, 185);
            }
            case 7: {
                return new Color(255, 255, 240);
            }
        }
        return Color.black;
    }

    public Color getPlayerColor() {
        return Island.getPlayerColor(this.idPlayer);
    }

    public int getIdPlayer() {
        return this.idPlayer;
    }

    public void setIdPlayer(int id) {
        this.idPlayer = id;
    }

    public int getUnits() {
        return this.units;
    }

    public void setUnits(int nb) {
        this.units = nb;
    }

    public void addUnit() {
        ++this.units;
    }

    public String getName() {
        return this.name;
    }

    public boolean isInCircle(Point pos, int r) {
        Area me = new Area(this.getShape(true));
        Area other = new Area(new Ellipse2D.Double(pos.x - r, pos.y - r, r * 2, r * 2));
        me.intersect(other);
        return !me.isEmpty();
    }

    public void addReachablesIslands(Island is) {
        if (!this.reachablesIslands.contains(is)) {
            this.reachablesIslands.add(is);
            if (this.getAtoll() != is.getAtoll()) {
                this.getAtoll().addReachableAtoll();
            }
        }
    }

    public int getReachablesIslandsNumber() {
        return this.reachablesIslands.size();
    }

    public Island getReachableIsland(int id) {
        return this.reachablesIslands.get(id);
    }

    public boolean canReach(Island island) {
        this.tryReach = true;
        int i = 0;
        while (i < this.reachablesIslands.size()) {
            Island is = this.reachablesIslands.get(i);
            if (island == is || !is.tryReach && is.canReach(island)) {
                this.tryReach = false;
                return true;
            }
            ++i;
        }
        this.tryReach = false;
        return false;
    }

    public boolean canTransfer(Island island) {
        this.tryTransfer = true;
        int i = 0;
        while (i < this.reachablesIslands.size()) {
            Island is = this.reachablesIslands.get(i);
            if (island == is || !is.tryTransfer && is.getIdPlayer() == this.idPlayer && is.canTransfer(island)) {
                this.tryTransfer = false;
                return true;
            }
            ++i;
        }
        this.tryTransfer = false;
        return false;
    }

    public boolean canReachDirectly(Island is) {
        return this.reachablesIslands.contains(is);
    }
}

